#--------------------------------------------------------
#	Script PiXYZ STUDIO - Fix FBX Tree
#
#	This Python script is meant to be used in PiXYZ STUDIO 2018
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	
#	This script can be used to fix the Product structure (or Tree) of an FBX file imported in PiXYZ STUDIO
#	by removing the additionnal Assembly nodes added as a parent of each part at import
#
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

for path in scene.getPartPaths():
	if len(path) < 3: continue
	part = path[-1]
	parent = path[-2]
	print(core.getEntityTypeString(parent))
	if core.getEntityTypeString(parent) != "Assembly": continue
	print(len(scene.getChildren(path[:-1])))
	if len(scene.getChildren(path[:-1])) != 1: continue
	grandParent = path[-3]
	print(core.getEntityTypeString(grandParent))
	if core.getEntityTypeString(grandParent) != "Assembly": continue
	scene.setParent(part, grandParent)
	core.setProperty(part, "Name", core.getProperty(parent, "Name"))
	if core.getProperty(part, "Material") == "0":
		core.setProperty(part, "Material", core.getProperty(parent, "Material"))
	core.setProperty(part, "TransformationMatrix", core.getProperty(parent, "TransformationMatrix"))
	core.setProperty(part, "Visible", core.getProperty(parent, "Visible"))
	core.deleteEntities([parent])